const TelegramBot = require('node-telegram-bot-api');
const { token, ownerId, prefixId, minDigits } = require('./settings');

const bot = new TelegramBot(token, { polling: true });
console.log('✅ Bot BuktiTF siap!');

/* ---------- HELPER ---------- */
const pad = (n, len) => n.toString().padStart(len, '0');
const generateId = () => {
  const rand = Math.floor(Math.random() * 10 ** minDigits);
  return `${prefixId}${pad(rand, minDigits)}`;
};

/* ---------- HANDLE FOTO SAJA ---------- */
bot.on('photo', async (msg) => {
  const uid = msg.from.id;
  const fileId = msg.photo[msg.photo.length - 1].file_id;

  /* buat ID & timestamp */
  const payId = generateId();
  const dateStr = new Date().toLocaleString('id-ID', { timeZone: 'Asia/Jakarta' });

  /* caption lengkap untuk owner */
  const captionOwner = `
📸 Bukti Transfer Masuk
┏━━━━━━━━━━━━━
┃ ID Payment : ${payId}
┃ Waktu      : ${dateStr}
┃ Pengirim   : @${msg.from.username || 'tanpa_username'}
┃ ID Tg      : ${uid}
┗━━━━━━━━━━━━━
  `.trim();

  /* forward foto + caption ke owner */
  await bot.sendPhoto(ownerId, fileId, { caption: captionOwner });

  /* balas ke user */
  await bot.sendMessage(uid, `
✅ Bukti transfer berhasil dikirim!
📋 ID Payment kamu: *${payId}*
🕐 Tanggal/jam: ${dateStr}

Silakan tunggu owner memeriksa.
  `.trim(), { parse_mode: 'Markdown' });
});

/* ---------- OWNER CEK STAT ---------- */
bot.onText(/\/start/, msg => {
  if (msg.from.id.toString() !== ownerId) return;
  bot.sendMessage(ownerId, '📊 Bot BuktiTF aktif & siap menerima foto.');
});

console.log('🟢 BOT BuktiTF berjalan...');